<?php
/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Layout\LayoutHelper;
use \Joomla\CMS\Access\Access;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GavisitsigninHelper;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GaqrcodeHelper;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GaencryptHelper;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\phpqrcode\phpqrcode;

include 'administrator/components/com_gavisitsignin/src/Helper/phpqrcode/qrlib.php';

// load any assets required
$this->document->getWebAssetManager()
    ->usePreset('com_gavisitsignin.gavisitsigninpreset')
    ->useScript('com_gavisitsignin.barcode');

// Load admin language file
Factory::getApplication()->getLanguage()->load('com_gavisitsignin', JPATH_ADMINISTRATOR, 'en-GB', true);

$user  = GavisitsigninHelper::getSpecificUser();

$printOutput  = $this->state->get('printOutput',0);
$listOrder  = $this->state->get('list.ordering','a.name');
$listDirn   = $this->state->get('list.direction','desc');
$canCreate  = $user->authorise('core.create', 'com_gavisitsignin');
$canEdit    = $user->authorise('core.edit', 'com_gavisitsignin');
$canCheckin = $user->authorise('core.manage', 'com_gavisitsignin');
$canChange  = $user->authorise('core.edit.state', 'com_gavisitsignin');
$canDelete  = $user->authorise('core.delete', 'com_gavisitsignin');
// get set committee group & then all users in it
$comGroup = $this->params->get('com_group', 8);
$committee = Access::getUsersByGroup($comGroup);
$secureIt = $this->params->get('secureIt', '');
$allow_visitors = $this->params->get('allow_visitors', 0);
$enDecrypt = $this->params->get('enDecrypt', 1);
$qr_loc = $this->params->get('qr_location', 'images/members/qrcodes');
$cntr = 0;
$today = date_format(Factory::getDate('now', 'Australia/Melbourne'),'Y-m-d');  //returns a date string in local timezone

$baseURL = 'index.php?';
$visitorLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'attendanceform.edit', 'id', 0);
$visitURL = $baseURL.\http_build_query($visitorLink, '', '&amp;');
$signOutLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'members.signoutall', 'id', 0);
$signOutURL = $baseURL.\http_build_query($signOutLink, '', '&amp;');
$printLink = GavisitsigninHelper::getHTTPQuery(null, 'view', 'members', 'p', 1);
$printLink = GavisitsigninHelper::getHTTPQuery($printLink, null, null, 'tmpl', 'component');
$printURL = $baseURL.\http_build_query($printLink, '', '&amp;');
$optBox = 'media/com_gavisitsignin/images/OptionBoxes.png';
$optBoxCom = 'media/com_gavisitsignin/images/OptionBoxesCom.png';

// setup the encryption/decryption elements
$code = GaencryptHelper::GaSetupCrypt();

// setup name badge header
$nb_head = '<div class="center" style="width:98%;background-color:white;"><img src="images/headers/doco_header.jpg" width="320px" />';
$cntItems = count($this->items);

//GavisitsigninHelper::gaPrint($committee);
/*
GavisitsigninHelper::gaPrint(Factory::getApplication()->getUserState('com_gavisitsignin.test.data'));
*/
?>
<script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
<div id="reader" width="600px">
    <input type="text" name="scanCode" id="scanCode" class="hidden" value=""/>
</div>
<h2><?php echo Text::_('COM_GAVISITSIGNIN_TITLE_MEMBERS'); ?></h2>

<form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post"
      name="adminForm" id="adminForm" class="com-content-category__articles">

<?php if (!$printOutput) : ?>
	<?php echo LayoutHelper::render('default_filter', array('view' => $this), dirname(__FILE__)); ?>
<?php endif; ?>

    <div class="table-responsive com-contact-categories categories-list">
	<table class="table table-striped" id="attendanceList">
		<thead>
		<tr>
			<th class='center' colspan="3">
				<p class='center --red'><?php echo Text::_('COM_GAVISITSIGNIN_ATTENDANCES_INSTRUCT'); ?></p>
			</th>

		</tr>
		</thead>
		<tfoot>
		<tr>
			<td colspan="<?php echo isset($this->items[0]) ? count(get_object_vars($this->items[0])) : 10; ?>">
				<?php echo $this->pagination->getListFooter(); ?>
			</td>
		</tr>
		</tfoot>
		<tbody>

			<?php if ($allow_visitors): ?>
				<tr><td colspan="3" class="center">
				<figure class="center">
				<a style="color:#3c4d91;" href="<?php echo Route::_($visitURL); ?>">
					<?php
                        QRcode::png('0-visitor', 'images/members/qrcodes/visitor.png');
                        $visitImg = '<img src="images/members/qrcodes/visitor.png" />';
                        echo $visitImg;
                    ?>
				</a>
				<figcaption class="center" style="color:#424242;">Visitor</figcaption>
				</figure>
				</td></tr>
			<?php endif; ?>

			<?php foreach ($this->items as $i => $item) : ?>
				<?php 
                    $canEdit = $user->authorise('core.edit', 'com_gavisitsignin');
                    if (!$canEdit && $user->authorise('core.edit.own', 'com_gavisitsignin')) {
                        $canEdit = $user->id == $item->created_by;
                    }
    				$cntr++;
    				$id = $user->id == 0 ? $user->id : $item->user_id;
    				$item->secureIt = 's='.$secureIt;
    				
    				$skillOpt = in_array($item->user_id, $committee) ? $optBoxCom : $optBox;

                    $signedIn = GavisitsigninHelper::checkSignInDate($item->user_id, $today);
                    $siClass = !empty($signedIn) ? ' style="background-color:var(--success);"' : ' style="background-color:var(--danger);"';

                    $item->scanCode = $item->secureIt.'&user_id='.$item->id.'&username='.$item->username;

                    // encrypt it or setup array of elements
                    if ($enDecrypt) {
                        $item->sUserCode = GaencryptHelper::GaEncrypt(substr($item->scanCode,2), $code);
                    } else {
                        $item->sUserCode = array('s'=>$secureIt,'user_id'=>$item->id,'username'=>$item->username);
                    }

                    // setup QR filename
                    $filecode = $item->id.'-'.str_replace(' ', '', $item->name);
                    $filename = $qr_loc.'/'.$filecode.'.png';

                    // generate new image if none exists
                    if ($enDecrypt || !file_exists($filename)) {
                        QRcode::png($item->scanCode, $filename);
                    }
                    $hsize = strlen($item->last_name) > 8 ? 3 : 2;
                    $hsize = strlen($item->last_name) > 10 ? 4 : $hsize;
                    $hsize = strlen($item->last_name) > 13 ? 5 : $hsize;
                    $lastName = ucfirst(strtolower($item->last_name));

                    // break the name down to an array of characters
                    $surnameArr = str_split($lastName);
                    // test for Mc and Mac names to capitalise next char
                    if ($surnameArr[0] == 'M' && $surnameArr[1] == 'c') {
                        $surnameArr[2] = strtoupper($surnameArr[2]);
                        $surname = implode("", $surnameArr);
                    } else {
                        if ($surnameArr[0] == 'M' && $surnameArr[1] == 'a' && $surnameArr[2] == 'c') {
                            $surnameArr[3] = strtoupper($surnameArr[3]);
                            $surname = implode("", $surnameArr);
                        } else {
                            $surname = $lastName;
                        }
                    }
                    // test for apostrophe type names
                    if ($surnameArr[0] == "O" && $surnameArr[1] == "'") {
                        $surnameArr[2] = strtoupper($surnameArr[2]);
                        $surname = implode("", $surnameArr);
                    }

                    $src_img = $nb_head.'<h1 style="padding-top:5px;text-align:center;">'.$item->first_name;
                    $src_img .='<img style="float:right;max-width:150px;" src="'.$filename.'" title="QR" /></h1>';
                    $src_img .='<h'.$hsize.' style="text-align:center;">'.$surname.'</h'.$hsize.'>';
                    $src_img .='<img style="margin:5px 0 10px 0;max-width:250px;" src="'.$skillOpt.'" title="Skills" /></div>';

                    // create the URL using the encrypted code
                    $signinURL = GavisitsigninHelper::signInOut($item->sUserCode);

                ?>
				<?php if ($cntr == 1): ?>
                    <tr class="row<?php echo $i % 2; ?>" style="line-height:60px;">
						<td class="center"<?php echo $siClass; ?>>
							<figure class="center">
							<a style="text-decoration:none;" href="<?php echo Route::_($signinURL); ?>">
								<?php echo $src_img; ?>
							</a>
							<figcaption class="center"><?php //echo $checkedOut; ?></figcaption>
							</figure>

						</td>
				<?php elseif ($cntr == 2): ?>
    					<td class="center"<?php echo $siClass; ?>>
    						<figure class="center">
    						<a style="text-decoration:none;" href="<?php echo Route::_($signinURL); ?>">
    							<?php echo $src_img; ?>
    						</a>
    						<figcaption class="center"><?php //echo $checkedOut; ?></figcaption>
    						</figure>
    					</td>
				<?php else: $cntr = 0; ?>
						<td class="center"<?php echo $siClass; ?>>
							<figure class="center">
							<a style="text-decoration:none;" href="<?php echo Route::_($signinURL); ?>">
								<?php echo $src_img; ?>
							</a>
							<figcaption class="center"><?php //echo $checkedOut; ?></figcaption>
							</figure>
						</td>
					</tr>
	            <?php endif; ?>
			<?php endforeach; ?>

			<?php // clean up the table structure ?>
			<?php if ($cntr == 1 && $cntItems == 1): ?>
    			</td></tr>
			<?php elseif ($cntr == 1): ?>
				<td></td><td></td></tr>
			<?php elseif ($cntr == 2): ?>
				<td></td></tr>
			<?php endif; ?>

		</tbody>
	</table>
	<?php if ($canCheckin) : ?>
        <a class="btn btn-primary" href="<?php echo Route::_($signOutURL); ?>"><?php echo Text::_('COM_GAVISITSIGNIN_SIGNOUT'); ?></a>
        <a class="btn btn-warning" href="<?php echo Route::_($printURL); ?>" target="_blank"><?php echo Text::_('COM_GAVISITSIGNIN_PRINT'); ?></a>
    <?php endif; ?>
    </div>

	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>"/>
	<?php echo HTMLHelper::_('form.token'); ?>
</form>
