<?php
/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

use \Joomla\CMS\Factory;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\Session\SessionInterface;
use \Joomla\CMS\Application\SiteApplication;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GavisitsigninHelper;

//Load admin language file
Factory::getApplication()->getLanguage()->load('com_gavisitsignin', JPATH_ADMINISTRATOR, 'en-GB', true);

$wa = $this->document->getWebAssetManager()
    ->usePreset('com_gavisitsignin.gavisitsigninpreset');
GavisitsigninHelper::loadTmplStyleModal($wa);

$mias = Factory::getApplication()->getUserState('com_gavisitsignin.mia.data');
Factory::getApplication()->setUserState('com_gavisitsignin.mia.data', null);
//GavisitsigninHelper::gaPrint($this->items);

?>

<form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post"
      name="adminForm" id="adminForm" class="com-content-category__articles">
<div class="table-responsive com-contact-categories categories-list">
	<table class="table table-striped" id="miaList">
		<thead>
    		<tr>
    			<th class=''>
    				<?php echo Text::_('COM_GAVISITSIGNIN_ATTENDANCES_USER_ID'); ?>
    			</th>
    			<th class='center'>
    				<?php echo Text::_('COM_GAVISITSIGNIN_ATTENDANCES_LASTMSHIP_DATE'); ?>
    			</th>
    			<th class='center'>
    				<?php echo Text::_('COM_GAVISITSIGNIN_ATTENDANCES_CLOCKIN_DATE'); ?>
    			</th>
    			<th class='center'>
    				<?php echo Text::_('COM_GAVISITSIGNIN_ATTENDANCES_REGISTER_DATE'); ?>
    			</th>
    			<th class='center'>
    				<?php echo Text::_('COM_GAVISITSIGNIN_ATTENDANCES_LOGIN_DATE'); ?>
    			</th>
    		</tr>
		</thead>
		<tbody>
    		<?php foreach ($mias as $i => $item) : ?>
        		<tr>
        			<td class=''>
        				<?php echo $item->username; ?>
        			</td>
        			<td class='center'>
        				<?php echo isset($item->lastMship) ? HTMLHelper::date($item->lastMship, Text::_('COM_GAVISITSIGNIN_DISPLAY_DATE'), 'Australia/Melbourne'): ''; ?>
        			</td>
        			<td class='center'>
        				<?php echo $item->clockinDate; ?>
        			</td>
        			<td class='center'>
        				<?php echo isset($item->registerDate) ? HTMLHelper::date($item->registerDate, Text::_('COM_GAVISITSIGNIN_DISPLAY_DATE'), 'Australia/Melbourne'): ''; ?>
        			</td>
        			<td class='center'>
        				<?php echo isset($item->lastLoginDate) && $item->lastLoginDate != 'Never Logged In' ? HTMLHelper::date($item->lastLoginDate, Text::_('COM_GAVISITSIGNIN_DISPLAY_DATE'), 'Australia/Melbourne'): $item->lastLoginDate; ?>
        			</td>
        		</tr>
    		<?php endforeach; ?>
		</tbody>
	</table>
</div>
</form>
