<?php
/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Layout\LayoutHelper;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GavisitsigninHelper;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GamodalHelper;

// load any assets required
$this->document->getWebAssetManager()
    ->usePreset('com_gavisitsignin.gavisitsigninpreset')
    ->useScript('com_gavisitsignin.barcode');

$user  = GavisitsigninHelper::getSpecificUser();

// Load admin language file
Factory::getApplication()->getLanguage()->load('com_gavisitsignin', JPATH_ADMINISTRATOR, 'en-GB', true);

$defOrder = 'SUBSTRING_INDEX(SUBSTRING_INDEX(attend_name, " ", 4), " ", -1)';
$listOrder  = $this->state->get('list.ordering', $defOrder);
$listDirn   = $this->state->get('list.direction', 'ASC');
$canCreate  = $user->authorise('core.create', 'com_gavisitsignin');
$canEdit    = $user->authorise('core.edit', 'com_gavisitsignin');
$canCheckin = $user->authorise('core.manage', 'com_gavisitsignin');
$canChange  = $user->authorise('core.edit.state', 'com_gavisitsignin');
$canDelete  = $user->authorise('core.delete', 'com_gavisitsignin');
$mias   = $this->state->get('filter.mias');

$adminList   = $this->params->get('admin_list', 0);
$fileName   = $this->params->get('fileName', 'images/members/export/signindata.csv');

$this->loggedin_userid = $canDelete ? true : false;

$baseURL = 'index.php?';
$outallLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'attendanceform.signoutall', null, null);
$outallURL = $baseURL.\http_build_query($outallLink, '', '&amp;');
$createLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'attendanceform.edit', 'id', 0);
if ($user->id) {
    $createLink = GavisitsigninHelper::getHTTPQuery($createLink, null, null, 'user_id', $user->id);
}
$createURL = $baseURL.\http_build_query($createLink, '', '&amp;');

$exportLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'attendances.exportCSV', null, null);
$expURL = $baseURL.\http_build_query($exportLink, '', '&amp;');

$label = 'COM_GAVISITSIGNIN_MIA';
$modalMIA = GamodalHelper::setupModalButton('task', 'attendances.checkMIA', 'id', 0, 'modalMIA', 'modalMIA', 'secondary', $label, $label, 'fa-solid fa-person-circle-question', null);

$prevVisit = new DateTime('1970-01-01');
$prevID = 0;
$today = Factory::getDate();

// get the last attendance for displaying how long since last.
if (!$adminList && !$canCheckin) {
    $lastSignIn = GavisitsigninHelper::getLastSignInDate($user->id);
    $clockin_date = new DateTime($lastSignIn->clockin_date);
    $daysSince = ($today >= $clockin_date) ? date_diff($today, $clockin_date)->format('%a days') : '';
    $lastLogin = HTMLHelper::date($lastSignIn->clockin_date, Text::_('COM_GAVISITSIGNIN_DISPLAY_DATETXT'), 'Australia/Melbourne');
}
//$mia = GavisitsigninHelper::getMIArecords(60);

//GavisitsigninHelper::gaPrint(Factory::getApplication()->getUserState('com_gavisitsignin.test.data'));
//GavisitsigninHelper::gaPrint($testDate);
?>

<h2><?php echo Text::_('COM_GAVISITSIGNIN_TITLE_ATTENDANCES'); ?></h2>

<form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post"
      name="adminForm" id="adminForm" class="com-content-category__articles">

	<?php echo LayoutHelper::render('default_filter', array('view' => $this), dirname(__FILE__)); ?>

    <?php if (!$adminList && !$canCheckin) : ?>
        <p><?php echo Text::sprintf('COM_GAVISITSIGNIN_LAST_ATTENDANCE', $lastLogin, $daysSince); ?></p>
    <?php endif; ?>

    <div class="table-responsive com-contact-categories categories-list">
	<table class="table table-striped" id="attendanceList">
		<thead>
		<tr>
			<?php if (isset($this->items[0]->state)): ?>
				<th width="5%">
					<?php echo HTMLHelper::_('grid.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
				</th>
			<?php endif; ?>

			<th class=''>
				<?php echo HTMLHelper::_('grid.sort',  'COM_GAVISITSIGNIN_ATTENDANCES_USER_ID', 'attend_name', $listDirn, $listOrder); ?>
			</th>
			<th class='center'>
				<?php echo HTMLHelper::_('grid.sort',  'COM_GAVISITSIGNIN_ATTENDANCES_CLOCKIN_DATE', 'a.clockin_date', $listDirn, $listOrder); ?>
			</th>
			<?php //if (!$adminList) : ?>
				<th class="center">
    				<?php echo Text::_('COM_GAVISITSIGNIN_DAYS_BETWEEN_VISITS'); ?>
				</th>
			<?php //else : ?>
                <th class='center'>
    				<?php echo HTMLHelper::_('grid.sort',  'COM_GAVISITSIGNIN_ATTENDANCES_CLOCKOUT_DATE', 'a.clockout_date', $listDirn, $listOrder); ?>
    			</th>
			<?php //endif; ?>

			<?php if ($canEdit || $canDelete): ?>
				<th class="center">
				<a href="#"><?php echo Text::_('COM_GAVISITSIGNIN_ACTIONS'); ?></a>
				</th>
			<?php endif; ?>

		</tr>
		</thead>
		<tfoot>
		<tr>
			<td colspan="<?php echo isset($this->items[0]) ? count(get_object_vars($this->items[0])) : 10; ?>">
				<?php echo $this->pagination->getListFooter(); ?>
			</td>
		</tr>
		</tfoot>
		<tbody>
		<?php foreach ($this->items as $i => $item) : ?>
			<?php
                $canEdit = $user->authorise('core.edit', 'com_gavisitsignin');
                if (!$canEdit && $user->authorise('core.edit.own', 'com_gavisitsignin')) {
                    $canEdit = $user->id == $item->created_by;
                }
                if ($prevID != $item->user_id) { $prevVisit = new DateTime($item->registerDate); }
                
                // calc days between visits
                $clockin_date = new DateTime($item->clockin_date);
                $daysSince = ($prevVisit <= $clockin_date && $prevID == $item->user_id) ? date_diff($prevVisit, $clockin_date)->format('%a days') : '';
                $prevVisit = $clockin_date;
                $prevID = $item->user_id;

                $outLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'attendance.signInOut', 'user_id', $item->user_id);
                $outURL = $baseURL.\http_build_query($outLink, '', '&amp;');
                $viewLink = GavisitsigninHelper::getHTTPQuery(null, 'view', 'attendance', 'id', $item->id);
                $viewURL = $baseURL.\http_build_query($viewLink, '', '&amp;');
                $remLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'attendanceform.remove', 'id', $item->id);
                $remURL = $baseURL.\http_build_query($remLink, '', '&amp;');
                $arcLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'attendanceform.archive', 'id', $item->id);
                $arcURL = $baseURL.\http_build_query($arcLink, '', '&amp;');
                $visLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'attendanceform.visitorOut', 'id', $item->id);
                $visURL = $baseURL.\http_build_query($visLink, '', '&amp;');
                $pubLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'attendance.publish', 'id', $item->id);
                $pubLink = GavisitsigninHelper::getHTTPQuery($pubLink, null, null, 'state', (($item->state + 1) % 2));
                $pubURL = $baseURL.\http_build_query($pubLink, '', '&amp;');

                $unpubLink = GavisitsigninHelper::getHTTPQuery(null, 'task', 'attendance.publish', 'id', $item->id);
                $unpubLink = GavisitsigninHelper::getHTTPQuery($unpubLink, null, null, 'state', 0);
                $unpubURL = $baseURL.\http_build_query($unpubLink, '', '&amp;');
            ?>

			<tr class="row<?php echo $i % 2; ?>">

				<?php if (isset($this->items[0]->state)) : ?>
					<?php $class = ($canChange) ? 'active' : 'disabled'; ?>
					<td class="center">
						<?php if ($item->state == -2): ?>
						<a class="btn btn-micro <?php echo $class; ?>" href="<?php echo ($canChange) ? Route::_($unpubURL, false, 2) : '#'; ?>">
						<?php else : ?>
						<a class="btn btn-micro <?php echo $class; ?>" href="<?php echo ($canChange) ? Route::_($pubURL, false, 2) : '#'; ?>">
						<?php endif; ?>
						<?php if ($item->state == 1): ?>
							<i class="icon-publish" title="Active"></i>
						<?php elseif ($item->state == 0): ?>
							<i class="icon-unpublish" title="Not Active"></i>
						<?php elseif ($item->state == -2): ?>
							<i class="icon-trash" title="Trashed"></i>
						<?php elseif ($item->state == 2): ?>
							<i class="icon-archive" title="Archived"></i>
						<?php endif; ?>
						</a>
					</td>
				<?php endif; ?>

				<td>
					<?php if (isset($item->checked_out) && $item->checked_out) : ?>
						<?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->uEditor, $item->checked_out_time, 'attendances.', $canCheckin); ?>
					<?php endif; ?>
					<a style="color:#3c4d91;" href="<?php echo Route::_($viewURL); ?>">
						<?php echo $item->attend_name; ?>
					</a>
				</td>
				<td class="center">
					<?php echo isset($item->clockin_date) ? HTMLHelper::date($item->clockin_date, Text::_('COM_GAVISITSIGNIN_DISPLAY_DATETXT'), 'Australia/Melbourne') : ''; ?>
				</td>
				<?php //if (!$adminList) : ?>
                    <td class="center">
    					<?php echo $daysSince; ?>
    				</td>
				<?php //else : ?>
                    <td class="center">
    					<?php echo isset($item->clockout_date) ? HTMLHelper::date($item->clockout_date, Text::_('COM_GAVISITSIGNIN_DISPLAY_DATETXT'), 'Australia/Melbourne') : ''; ?>
    				</td>
				<?php //endif; ?>

				<?php if ($canEdit || $canDelete): ?>
					<td class="center">
						<?php if ($canEdit && !$item->user_id && (empty($item->clockout_date) || $item->clockout_date == '0000-00-00 00:00:00')): ?>
							<a href="<?php echo Route::_($visURL, false, 2); ?>" class="btn btn-secondary btn-sm" type="button" >
                                <i class="icon-undo" title="Sign Out"></i>
                            </a>
						<?php endif; ?>
						<?php if ($canEdit && $item->user_id && (empty($item->clockout_date) || $item->clockout_date == '0000-00-00 00:00:00')): ?>
							<a href="<?php echo Route::_($outURL, false, 2); ?>" class="btn btn-secondary btn-sm" type="button">
                                <i class="icon-undo" title="Sign Out"></i>
                            </a>
						<?php endif; ?>
						<?php if ($canDelete): ?>
							<a href="<?php echo Route::_($remURL, false, 2); ?>" class="btn btn-secondary btn-sm delete-button" type="button" >
                                <i class="icon-trash" title="Delete Record"></i>
                            </a>
							<a href="<?php echo Route::_($arcURL, false, 2); ?>" class="btn btn-secondary btn-sm" type="button">
                                <i class="icon-archive" title="Archive Record"></i>
                            </a>
						<?php endif; ?>
					</td>
				<?php endif; ?>

			</tr>
		<?php endforeach; ?>
		</tbody>
	</table>
    </div>
	<?php if ($canCreate) : ?>
		<a href="<?php echo Route::_($createURL, false, 0); ?>" class="btn btn-success">
            <i class="icon-plus"></i> <?php echo Text::_('COM_GAVISITSIGNIN_ADD_ITEM'); ?>
		</a>
	<?php endif; ?>
	<?php if ($canDelete) : ?>
		<a href="<?php echo Route::_($outallURL, false, 0); ?>" class="btn btn-warning pull-right">
            <i class="fas fa-user-check"></i> <?php echo Text::_('COM_GAVISITSIGNIN_CHECKOUT_ALL'); ?>
		</a>
        <a class="btn btn-secondary" href="<?php echo Route::_($expURL); ?>"><?php echo Text::_('COM_GAVISITSIGNIN_EXPORT'); ?></a>
        <?php if (\is_file($fileName)) : ?>
            <a class="btn btn-info" href="<?php echo $fileName; ?>"><i class="icon-search"></i></a>
        <?php endif; ?>
        <?php echo $modalMIA; ?>
	<?php endif; ?>

	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>"/>
	<?php echo HTMLHelper::_('form.token'); ?>
</form>

