<?php
/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language\Text;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GavisitsigninHelper;

// load any assets required
$this->document->getWebAssetManager()
    ->usePreset('com_gavisitsignin.gavisitsigninpreset')
    ->useScript('keepalive')
	->useScript('form.validate');

$user  = GavisitsigninHelper::getSpecificUser();

// Load admin language file
$lang = Factory::getLanguage();
$lang->load('com_gavisitsignin', JPATH_ADMINISTRATOR);

// check if existing record
if (isset($this->item->id)) {
	$id = $this->item->id;
	$user_id = $this->item->user_id;
	$attendee_name = $this->item->user_id ? $this->item->user_id_name : $this->item->name;
} else {
	$id = 0;
	$user_id = 0;
	$attendee_name = 'a Visitor';
}
?>

<div class="attendance-edit front-end-edit">
	<h3><?php echo Text::sprintf('COM_GAVISITSIGNIN_ADD_ATTENDANCE', $attendee_name); ?></h3>

	<form id="form-attendance"
		  action="<?php echo Route::_('index.php?option=com_gavisitsignin&task=attendanceform.save'); ?>"
		  method="post" class="form-validate form-horizontal" enctype="multipart/form-data">
		<input type="hidden" name="jform[id]" value="<?php echo $id; ?>" />
		<?php if ($user_id) : ?>
			<input type="hidden" name="jform[user_id]" value="<?php echo $user_id; ?>" />
			<?php echo $this->form->renderField('comment'); ?>
		<?php else : ?>
			<input type="hidden" name="jform[user_id]" value="0" />
			<?php echo $this->form->renderField('visit_who'); ?>
			<?php echo $this->form->renderField('name'); ?>
			<?php echo $this->form->renderField('phone'); ?>
			<?php echo $this->form->renderField('address'); ?>
			<?php echo $this->form->renderField('suburb'); ?>
			<?php echo $this->form->renderField('postcode'); ?>
			<?php echo $this->form->renderField('comment'); ?>
		<?php endif; ?>

		<div class="control-group">
			<div class="controls">
				<?php if ($user->authorise('core.create', 'com_gavisitsignin')): ?>
					<button type="submit" class="validate btn btn-primary">
						<?php echo Text::_('JSUBMIT'); ?>
					</button>
				<?php endif; ?>
				<button type="button" class="btn btn-secondary" onclick="Joomla.submitbutton('attendanceform.cancel')">
					<span class="icon-undo" aria-hidden="true"></span>
					<?php echo Text::_('JCANCEL'); ?>
				</button>
			</div>
		</div>

		<input type="hidden" name="option" value="com_gavisitsignin"/>
		<input type="hidden" name="task"
			   value="attendanceform.save"/>
		<?php echo HTMLHelper::_('form.token'); ?>
	</form>

</div>
