<?php
/**
 * @version    5.0.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language\Text;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GavisitsigninHelper;

// load any assets required
$this->document->getWebAssetManager()
    ->usePreset('com_gavisitsignin.gavisitsigninpreset')
    ->useScript('com_gavisitsignin.barcode')
    ->useScript('keepalive')
	->useScript('form.validate');

$user  = GavisitsigninHelper::getSpecificUser();

// Load admin language file
$lang = Factory::getLanguage();
$lang->load('com_gavisitsignin', JPATH_ADMINISTRATOR);

?>

<div class="attendance-edit front-end-edit">
	<h3><?php echo Text::sprintf('COM_GAVISITSIGNIN_ADD_ATTENDANCE', $attendee_name); ?></h3>

	<form id="form-attendance"
		  action="<?php echo Route::_('index.php?option=com_gavisitsignin&task=attendance.signInOut'); ?>"
		  method="post" class="form-validate form-horizontal" enctype="multipart/form-data">
		<input type="hidden" name="jform[id]" value="0" />
		<?php echo $this->form->renderField('userCode'); ?>
		<div class="control-group">
			<div class="controls">
				<button type="submit" class="validate btn btn-primary">
					<?php echo Text::_('JSUBMIT'); ?>
				</button>
				<button type="button" class="btn btn-secondary" onclick="Joomla.submitbutton('attendanceform.cancel')">
					<span class="icon-undo" aria-hidden="true"></span>
					<?php echo Text::_('JCANCEL'); ?>
				</button>
			</div>
		</div>
        <div id="reader" width="600px"></div>

		<input type="hidden" name="option" value="com_gavisitsignin"/>
		<input type="hidden" name="task" value="attendance.signInOut"/>
		<?php echo HTMLHelper::_('form.token'); ?>
	</form>

</div>
