<?php
/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Date\Date;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GavisitsigninHelper;

// load any assets required
$this->document->getWebAssetManager()
    ->usePreset('com_gavisitsignin.gavisitsigninpreset');

$app   = Factory::getApplication();
$user  = $app->getIdentity();

// Load admin language file
$lang = $app->getLanguage();
$lang->load('com_gavisitsignin', JPATH_ADMINISTRATOR);

$canCreate  = $user->authorise('core.create', 'com_gavisitsignin');
$canEdit    = $user->authorise('core.edit', 'com_gavisitsignin');
$canCheckin = $user->authorise('core.manage', 'com_gavisitsignin');
$canChange  = $user->authorise('core.edit.state', 'com_gavisitsignin');
$canDelete  = $user->authorise('core.delete', 'com_gavisitsignin');

if (!$canEdit && $user->authorise('core.edit.own', 'com_gavisitsignin')) {
	$canEdit = $user->id == $this->item->created_by;
}
if ($this->item->user_id) {
	$attendee_name = $this->item->user_id_name;
} else {
	$attendee_name = $this->item->name.' visiting '.$this->item->visit_who;
}

$indate = new Date($this->item->clockin_date); 
$indate_disp = $indate->format(Text::_('COM_GAVISITSIGNIN_DISPLAY_DATETIME'));
if ($this->item->clockout_date) {
	$outdate = new Date($this->item->clockout_date);
	$outdate_disp = $outdate->format(Text::_('COM_GAVISITSIGNIN_DISPLAY_DATETIME'));
} else {
	$outdate_disp = '';
}
?>

<h2><?php echo Text::_('COM_GAVISITSIGNIN_ATTENDANCE_DETAILS'); ?></h2>

<div class="item_fields">

	<table class="table">

		<tr>
			<th><?php echo Text::_('COM_GAVISITSIGNIN_FORM_LBL_ATTENDANCE_USER_ID'); ?></th>
			<td><?php echo $attendee_name; ?></td>
		</tr>

		<tr>
			<th><?php echo Text::_('COM_GAVISITSIGNIN_FORM_LBL_ATTENDANCE_CLOCKIN_DATE'); ?></th>
			<td><?php echo $indate_disp; ?></td>
		</tr>

		<tr>
			<th><?php echo Text::_('COM_GAVISITSIGNIN_FORM_LBL_ATTENDANCE_CLOCKOUT_DATE'); ?></th>
			<td><?php echo $outdate_disp; ?></td>
		</tr>

		<tr>
			<th><?php echo Text::_('COM_GAVISITSIGNIN_FORM_LBL_COMMENT'); ?></th>
			<td><?php echo nl2br($this->item->comment); ?></td>
		</tr>

	</table>

</div>

<a class="btn btn-secondary" href="<?php echo Route::_('index.php?option=com_gavisitsignin&view=attendances'); ?>">
	<i class="icon-undo"></i> <?php echo Text::_("COM_GAVISITSIGNIN_RETURN"); ?>
</a>

<?php if($canEdit && $this->item->checked_out == 0): ?>

	<a class="btn btn-warning" href="<?php echo Route::_('index.php?option=com_gavisitsignin&task=attendance.edit&id='.$this->item->id); ?>">
		<i class="icon-edit"></i> <?php echo Text::_("COM_GAVISITSIGNIN_EDIT_ITEM"); ?>
	</a>

<?php endif; ?>

<?php if ($user->authorise('core.delete','com_gavisitsignin.attendance.'.$this->item->id)) : ?>

	<a class="btn btn-danger pull-right" href="#deleteModal" role="button" data-toggle="modal">
		<?php echo Text::_("COM_GAVISITSIGNIN_DELETE_ITEM"); ?>
	</a>

	<div id="deleteModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="deleteModal" aria-hidden="true">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
			<h3><?php echo Text::_('COM_GAVISITSIGNIN_DELETE_ITEM'); ?></h3>
		</div>
		<div class="modal-body">
			<p><?php echo Text::sprintf('COM_GAVISITSIGNIN_DELETE_CONFIRM', $attendee_name.' '.$this->item->clockin_date); ?></p>
		</div>
		<div class="modal-footer">
			<button class="btn" data-dismiss="modal">Close</button>
			<a href="<?php echo Route::_('index.php?option=com_gavisitsignin&task=attendance.remove&id=' . $this->item->id, false, 2); ?>" class="btn btn-danger">
				<?php echo Text::_('COM_GAVISITSIGNIN_DELETE_ITEM'); ?>
			</a>
		</div>
	</div>

<?php endif; ?>

