<?php
/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gavisitsignin\Site\Model;

// No direct access.
defined('_JEXEC') or die;

use \Joomla\CMS\Factory;
use \Joomla\Utilities\ArrayHelper;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Table\Table;
use \Joomla\CMS\MVC\Model\FormModel;
use \Joomla\CMS\User\UserHelper;
use \Joomla\CMS\Component\ComponentHelper;
use \Joomla\Filesystem\File;
use \Joomla\Filesystem\Folder;
use \Joomla\Filesystem\Path;
use \Joomla\CMS\Plugin\PluginHelper;
use \Joomla\CMS\Date\Date;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GavisitsigninHelper;


/**
 * Form record model.
 *
 * @since  1.6
 */
class AttendanceformModel extends FormModel
{
    private $item = null;

    /**
     * Method to auto-populate the model state.
     * Note. Calling getState in this method will result in recursion.
     * @return void
     * @since  1.6
     * @throws Exception
     */
    protected function populateState()
    {
        $app = Factory::getApplication('com_gavisitsignin');
		$user_id = 0;
		$id = 0;
        // Load state from the request userState on edit or from the passed variable on default
        if ($app->input->get('layout') == 'edit') {
            $id = $app->getUserState('com_gavisitsignin.edit.attendance.id');
            $user_id = $app->getUserState('com_gavisitsignin.edit.attendance.user_id');
        } elseif ($app->input->get('layout') == 'visitor') {
            $id = $app->getUserState('com_gavisitsignin.edit.attendance.id');
            $user_id = $app->getUserState('com_gavisitsignin.edit.attendance.user_id');
        } else {
            $id = $app->input->get('id');
            $app->setUserState('com_gavisitsignin.edit.attendance.id', $id);
        }
        //$qrscanref = $app->getUserState('com_gavisitsignin.edit.attendance.qrscanref');

        $this->setState('attendance.id', $id);
        $this->setState('attendance.user_id', $user_id);
        //$this->setState('attendance.qrscanref', $qrscanref);

        // Load the parameters.
        $params       = $app->getParams();
        $params_array = $params->toArray();

        if (isset($params_array['item_id'])) {
            $this->setState('attendance.id', $params_array['item_id']);
        }

        $this->setState('params', $params);
    }

    /**
     * Method to get an ojbect.
     * @param   integer $id The id of the object to get.
     * @return Object|boolean Object on success, false on failure.
     * @throws Exception
     */
    public function getItem($id = null)
    {
		if ($this->item === null) {
            $this->item = false;

            if (empty($id)) {
                $id = $this->getState('attendance.id');
                $user_id = $this->getState('attendance.user_id');
            }

            // Get a level row instance.
            $table = $this->getTable();

            if ($table !== false && $table->load($id)) {
				$user = GavisitsigninHelper::getSpecificUser();
                $id   = $table->id;

                $canEdit = $user->authorise('core.edit', 'com_gavisitsignin') || $user->authorise('core.create', 'com_gavisitsignin');

                if (!$canEdit && $user->authorise('core.edit.own', 'com_gavisitsignin')) {
                        $canEdit = $user->id == $table->created_by;
                }

                if (!$canEdit) {
                        throw new Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
                }

                // Check published state.
                if ($published = $this->getState('filter.published')) {
                        if (isset($table->state) && $table->state != $published) {
                                return $this->item;
                        }
                }

                // Convert the JTable to a clean JObject.
                $properties = $table->getProperties(1);
                $this->item = ArrayHelper::toObject($properties, 'JObject');
                
            }

			if ($this->item->user_id) {
				$this->item->user_id_name = GavisitsigninHelper::getSpecificUser($this->item->user_id)->name;
			} else {
				$this->item->user_id = $user_id;
				$this->item->user_id_name = GavisitsigninHelper::getSpecificUser($user_id)->name;
			}
        }

        return $this->item;
    }

    /**
     * Method to get the table
     * @param   string $type   Name of the Table class
     * @param   string $prefix Optional prefix for the table class name
     * @param   array  $config Optional configuration array for JTable object
     * @return  JTable|boolean JTable if found, boolean false on failure
     */
    public function getTable($type = 'Attendance', $prefix = 'Administrator', $config = array())
    {
        return parent::getTable($type, $prefix, $config);
    }

    /**
     * Get an item by alias
     * @param   string $alias Alias string
     * @return int Element id
     */
    public function getItemIdByAlias($alias)
    {
        $table      = $this->getTable();
        $properties = $table->getProperties();

        if (!in_array('alias', $properties))
        {
                return null;
        }

        $table->load(array('alias' => $alias));

        return $table->id;

    }

    /**
     * Method to check in an item.
     * @param   integer $id The id of the row to check out.
     * @return  boolean True on success, false on failure.
     * @since    1.6
     */
    public function checkin($id = null)
    {
        // Get the id.
        $id = (!empty($id)) ? $id : (int) $this->getState('attendance.id');
        
        if ($id)
        {
            // Initialise the table
            $table = $this->getTable();

            // Attempt to check the row in.
            if (method_exists($table, 'checkin'))
            {
                if (!$table->checkin($id))
                {
                    return false;
                }
            }
        }

        return true;
        
    }

    /**
     * Method to check out an item for editing.
     * @param   integer $id The id of the row to check out.
     * @return  boolean True on success, false on failure.
     * @since    1.6
     */
    public function checkout($id = null)
    {
        // Get the user id.
        $id = (!empty($id)) ? $id : (int) $this->getState('attendance.id');
        
        if ($id)
        {
            // Initialise the table
            $table = $this->getTable();

            // Get the current user object.
			$user = GavisitsigninHelper::getSpecificUser();

            // Attempt to check the row out.
            if (method_exists($table, 'checkout'))
            {
                if (!$table->checkout($user->get('id'), $id))
                {
                    return false;
                }
            }
        }

        return true;
        
    }

    /**
     * Method to get the form.
     * The base form is loaded from XML
     * @param   array   $data     An optional array of data for the form to interogate.
     * @param   boolean $loadData True if the form is to load its own data (default case), false if not.
     * @return    JForm    A JForm object on success, false on failure
     * @since    1.6
     */
    public function getForm($data = array(), $loadData = true)
    {
        // Get the form.
        $form = $this->loadForm('com_gavisitsignin.attendance', 'attendanceform', array(
                        'control'   => 'jform',
                        'load_data' => $loadData
                )
        );

        if (empty($form)) {
                return false;
        }

        return $form;
    }

    /**
     * Method to get the data that should be injected in the form.
     * @return    mixed    The data for the form.
     * @since    1.6
     */
    protected function loadFormData()
    {
        $data = Factory::getApplication()->getUserState('com_gavisitsignin.edit.attendance.data', array());

        if (empty($data)) {
            $data = $this->getItem();
        }

        return $data;
    }

    /**
     * Method to save the form data.
     * @param   array $data The form data
     * @return bool
     * @throws Exception
     * @since 1.6
     */
    public function save($data)
    {
        $id    = (!empty($data['id'])) ? $data['id'] : (int) $this->getState('attendance.id');
        $data['state'] = 1;

        $user = GavisitsigninHelper::getSpecificUser();
        $today = Factory::getDate()->toSql();
        $data['clockin_date'] = $today;

        if ($id) {
            // Check the user can edit this item
            $authorised = $user->authorise('core.edit', 'com_gavisitsignin') || $authorised = $user->authorise('core.edit.own', 'com_gavisitsignin');
	        if ($authorised !== true) {
	            throw new Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
	        }
        } else {
            // Check the user can create new items in this section
            $authorised = $user->authorise('core.create', 'com_gavisitsignin');
	        if ($authorised !== true) {
	            throw new Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
	        }
        }

        $table = $this->getTable();

        if ($table->save($data) === true) {
            return $table->id;
        } else {
            return false;
        }
        
    }

    /**
     * Method to delete data
     * @param   int $pk Item primary key
     * @return  int  The id of the deleted item
     * @throws Exception
     * @since 1.6
     */
    public function delete($pk)
    {
		$user = GavisitsigninHelper::getSpecificUser();

        if (empty($pk)) {
            $pk = (int) $this->getState('attendance.id');
        }

        if ($pk == 0 || $this->getItem($pk) == null) {
            throw new Exception(Text::_('COM_GAVISITSIGNIN_ITEM_DOESNT_EXIST'), 404);
        }

        if ($user->authorise('core.delete', 'com_gavisitsignin') !== true) {
            throw new Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
        }

        $table = $this->getTable();
        $table->load($pk);
        $table->state = -2;

        if ($table->store($pk) !== true) {
            throw new Exception(Text::_('JERROR_FAILED'), 501);
        }

        return $pk;
        
    }

    /**
     * Method to archive data
     * @param   int $pk Item primary key
     * @return  int  The id of the deleted item
     * @throws Exception
     * @since 1.6
     */
    public function archive($pk)
    {
		$user = GavisitsigninHelper::getSpecificUser();

        if (empty($pk)) {
            $pk = (int) $this->getState('attendance.id');
        }

        if ($pk == 0 || $this->getItem($pk) == null) {
            throw new Exception(Text::_('COM_GAVISITSIGNIN_ITEM_DOESNT_EXIST'), 404);
        }

        if ($user->authorise('core.delete', 'com_gavisitsignin') !== true) {
            throw new Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
        }

        $table = $this->getTable();
        $table->load($pk);
        $table->state = 2;

        if ($table->store($pk) !== true) {
            throw new Exception(Text::_('JERROR_FAILED'), 501);
        }

        return $pk;
        
    }

    /**
     * Method to archive data
     * @param   int $pk Item primary key
     * @return  int  The id of the deleted item
     * @throws Exception
     * @since 1.6
     */
    public function visitorOut($pk)
    {
		$user = GavisitsigninHelper::getSpecificUser();

        if ($pk == 0 || $this->getItem($pk) == null) {
            throw new Exception(Text::_('COM_GAVISITSIGNIN_ITEM_DOESNT_EXIST'), 404);
        }

        if ($user->authorise('core.edit', 'com_gavisitsignin') !== true) {
            throw new Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
        }

		$table = $this->getTable();
        $table->load($pk);
        $table->clockout_date = Factory::getDate()->toSql();

        if ($table->store($pk) !== true) {
            throw new Exception(Text::_('JERROR_FAILED'), 501);
        }

        return $pk;
        
    }

    /**
     * Method to register the attendance.
     * @param   array $data The form data
     * @return bool
     */
    public function regattend($data)
    {
        $id    = (!empty($data['id'])) ? $data['id'] : 0;
        $data['state'] = 1;
        
        // get security code
        $scode = ComponentHelper::getParams('com_gavisitsignin')->get('secureIt');
        //compare passed data to identify member
        $data['user_id'] = str_replace($scode, '', $data['userCode']);

        $user = GavisitsigninHelper::getSpecificUser();
        $data['clockin_date'] = Factory::getDate()->toSql();

        if ($id) {
            // Check the user can edit this item
            $authorised = $user->authorise('core.edit', 'com_gavisitsignin') || $authorised = $user->authorise('core.edit.own', 'com_gavisitsignin');
	        if ($authorised !== true) {
	            throw new Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
	        }
        } else {
            // Check the authority link
        }

        $table = $this->getTable();

        if ($table->save($data) === true) {
            return $table->id;
        } else {
            return false;
        }
        
    }

}
