<?php
/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gavisitsignin\Site\Controller;

// No direct access.
defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Utilities\ArrayHelper;

/**
 * Records list controller class.
 */
class MembersController extends FormController
{
	/**
	 * Proxy for getModel.
	 * @param   string  $name    The model name.
	 * @param   string  $prefix  The class prefix.
	 * @param   array   $config  Configuration array for model.
	 * @return object	The model
	 * @since	1.6
	 */
	public function getModel($name = 'Members', $prefix = 'Site', $config = array())
	{
		return parent::getModel($name, $prefix, array('ignore_request' => true));
	}

	/**
	 * Method to sign out all remaining attenances.
	 * @return void
	 * @throws Exception
	 * @since  1.6
	 */
	public function signoutall()
	{
		// Check for request forgeries.
		//$this->checkToken();

		// Initialise variables.
		$app   = Factory::getApplication();
		$model = $this->getModel('Members', 'Site');

        // Attempt to update the data
        try
        {
            $return = $model->signOutAllAttendees();

            $menu = $app->getMenu();
            $item = $menu->getActive();
            $url = (empty($item->link) ? 'index.php?option=com_gavisitsignin&view=members' : $item->link);

            // Redirect to the list screen
            $this->setMessage(Text::_('COM_GAVISITSIGNIN_ALL_OUT_SUCCESSFULLY'), 'success');
            $this->setRedirect(Route::_($url, false));
        }
        catch (Exception $e)
        {
            $errorType = ($e->getCode() == '404') ? 'error' : 'warning';
            $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_ALL_OUT_FAILED',$e->getMessage()), $errorType);
            $this->setRedirect('index.php?option=com_gavisitsignin&view=members');
        }
    }

}
