<?php
/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gavisitsignin\Site\Controller;

// No direct access.
defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Utilities\ArrayHelper;

/**
 * Records list controller class.
 */
class AttendancesController extends FormController
{
	/**
	 * Proxy for getModel.
	 * @param   string  $name    The model name.
	 * @param   string  $prefix  The class prefix.
	 * @param   array   $config  Configuration array for model.
	 * @return object	The model
	 * @since	1.6
	 */
	public function getModel($name = 'Attendances', $prefix = 'Site', $config = array())
	{
		return parent::getModel($name, $prefix, array('ignore_request' => true));
	}

	/**
	 * Check for members not signed in for a period of time.
	 */
	public function checkMIA()
	{
		// Initialise variables.
		$app   = Factory::getApplication();
		$model = $this->getModel('Attendances', 'Site');
        $layout     = $app->input->get('layout', 'modalMIA');

		// Checking if the user can remove object
		$user  = $app->getIdentity();

		if ($user->authorise('core.manage', 'com_gavisitsignin'))
		{
            // Attempt to generate the data
            $return = $model->showMIA();

            if ($return) {
                $url = 'index.php?option=com_gavisitsignin&view=attendances&tmpl=component&layout='.$layout;
            } else {
                $app->enqueueMessage(Text::_('COM_GAVISITSIGNIN_FAILED'), 'danger');
                $url = 'index.php';
            }
            $this->setRedirect(Route::_($url, false));
        }
        else
        {
            $app->enqueueMessage(Text::_('COM_GAVISITSIGNIN_NOT_AUTHORISED'), 'danger');
            $this->setRedirect('index.php');
        }
	}

	/**
	 * Export Data for analysis.
	 */
	public function exportCSV()
	{
		// Initialise variables.
		$app   = Factory::getApplication();
		$model = $this->getModel('Attendances', 'Site');

		// Checking if the user can remove object
		$user  = $app->getIdentity();

		if ($user->authorise('core.manage', 'com_gavisitsignin'))
		{
            // Attempt to generate the data
            $return = $model->generateExport();

            if ($return) {
                $menu = $app->getMenu();
                $item = $menu->getActive();
                $url = (empty($item->link) ? 'index.php?option=com_gavisitsignin&view=attendances' : $item->link);
    
                // Redirect to the list screen
                $app->enqueueMessage(Text::_('COM_GAVISITSIGNIN_EXPORT_SUCCESSFULLY'), 'success');
                $app->enqueueMessage(Text::_('COM_GAVISITSIGNIN_EXPORT_READY'), 'success');
                $this->setRedirect(Route::_($url, false));
            } else {
                $app->enqueueMessage(Text::_('COM_GAVISITSIGNIN_EXPORT_FAILED'), 'danger');
                $this->setRedirect(Route::_($url, false));
            }
        }
        else
        {
            $app->enqueueMessage(Text::_('COM_GAVISITSIGNIN_NOT_AUTHORISED'), 'danger');
            $this->setRedirect('index.php');
        }
	}

}
