<?php

/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gavisitsignin\Site\Controller;

// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\Factory;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Session\Session;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\MVC\Controller\FormController;
use \Joomla\CMS\Component\ComponentHelper;

/**
 * Form record controller class.
 *
 * @since  1.6
 */
class AttendanceformController extends FormController
{
	/**
	 * Method to check out an item for editing and redirect to the edit form.
	 * @return void
	 * @since    1.6
     * @throws Exception
	 */
	public function edit($key = NULL, $urlVar = NULL)
	{
		$app = Factory::getApplication();
		$params = ComponentHelper::getParams('com_gavisitsignin');

		// Get the previous edit id (if any) and the current edit id.
		$previousId = (int) $app->getUserState('com_gavisitsignin.edit.attendance.id');
		$editId     = $app->input->getInt('id', 0);
		$user_id     = $app->input->getInt('user_id', 0);
		$qrscanref     = $app->input->get('ref', 0);

		// Set the record id for the user to edit in the session.
		$app->setUserState('com_gavisitsignin.edit.attendance.id', $editId);
		$app->setUserState('com_gavisitsignin.edit.attendance.user_id', $user_id);
		$app->setUserState('com_gavisitsignin.edit.attendance.qrscanref', $qrscanref);

		// Get the model.
		$model = $this->getModel('Attendanceform', 'Site');

		// Check out the item
		if ($editId) {
			$model->checkout($editId);
		}

		// Check in the previous user.
		if ($previousId) {
			$model->checkin($previousId);
		}

		if (!$user_id && $params->get('allow_visitors', 0)) {
    		$this->setRedirect(Route::_('index.php?option=com_gavisitsignin&view=attendanceform&layout=visitor', false));
        } else {
    		$this->setRedirect(Route::_('index.php?option=com_gavisitsignin&view=attendanceform&layout=edit', false));
    	}


//         $Menuyesno = $params->get('hide_menus', 0) ? '&tmpl=component' : '';
//         $URL_Link = 'index.php?option=com_gavisitsignin&view=attendanceform';
//         //$app->setUserState('com_gavisitsignin.test.data',$URL_Link.$Menuyesno.'&layout=edit');
// 		if (!$user_id && $params->get('allow_visitors', 0)) {
// 				// go to the form and register a visitor
// 				$this->setRedirect(Route::_($URL_Link.$Menuyesno.'&layout=visitor', false));
// 		} else {
// 			if ($qrscanref) {
// 				if ($params->get('qr_suffix', '') == $qrscanref) {
// 	                // result returns the name of the individual and text relating to signed in or out
// 					if ($params->get('auto_reg', 0)) {
// 						$result = $model->autoRegisterAttendance($qrscanref);
// 		                if ($result) {
// 		                    $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_AUTOLOAD_SUCCESSFULLY', $result), 'success');
// 		                } else {
// 							$this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_AUTOLOAD_FAILED', $result), 'warning');
// 						}
// 					} else {
// 						$this->setRedirect(Route::_($URL_Link.$Menuyesno.'&layout=edit', false));
// 		            }
// 				} else {
// 					$this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_AUTOLOAD_QRMATCH_FAILED', $qrscanref), 'danger');
// 				}
// 				//$this->setRedirect(Route::_('index.php', false));
// 		$this->setRedirect(Route::_('index.php?option=com_gavisitsignin&view=attendanceform&layout=edit', false));
// 			} else {
// 				if ($params->get('auto_reg', 0)) {
// 					$result = $model->autoRegisterAttendance($qrscanref);
// 	                if ($result) {
// 	                    $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_AUTOLOAD_SUCCESSFULLY', $result), 'success');
// 	                } else {
// 						$this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_AUTOLOAD_FAILED', $result), 'warning');
// 					}
// 				} else {
// 					$this->setRedirect(Route::_($URL_Link.$Menuyesno.'&layout=edit', false));
// 	            }
// 				// Redirect to the home screen.
// 				$this->setRedirect(Route::_('index.php', false));
// 			}
//		}
	}

	/**
	 * Method to save a user's profile data.
	 * @return void
	 * @throws Exception
	 * @since  1.6
	 */
	public function save($key = NULL, $urlVar = NULL)
	{
		// Check for request forgeries.
		$this->checkToken();

		// Initialise variables.
		$app   = Factory::getApplication();
		$model = $this->getModel('Attendanceform', 'Site');

		// Get the submitted data.
		$data = $app->input->get('jform', array(), 'array');

		// Validate the posted data.
		$form = $model->getForm();

		if (!$form) {
			throw new Exception($model->getError(), 500);
		}

		// Validate the posted data.
		$data = $model->validate($form, $data);

		// Check for errors.
		if ($data === false) {
			// Get the validation messages.
			$errors = $model->getErrors();

			// Push up to three validation messages out to the user.
			for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
				if ($errors[$i] instanceof Exception) {
					$app->enqueueMessage($errors[$i]->getMessage(), 'warning');
				} else {
					$app->enqueueMessage($errors[$i], 'warning');
				}
			}

			$input = $app->input;
			$jform = $input->get('jform', array(), 'ARRAY');

			// Save the data in the session.
			$app->setUserState('com_gavisitsignin.edit.attendance.data', $jform);

			// Redirect back to the edit screen.
			$id = (int) $app->getUserState('com_gavisitsignin.edit.attendance.id');
			$this->setRedirect(Route::_('index.php?option=com_gavisitsignin&view=attendanceform&layout=edit&id=' . $id, false));

			$this->redirect();
		}

		// Attempt to save the data.
		$return = $model->save($data);

		// Check for errors.
		if ($return === false) {
			// Save the data in the session.
			$app->setUserState('com_gavisitsignin.edit.attendance.data', $data);

			// Redirect back to the edit screen.
			$id = (int) $app->getUserState('com_gavisitsignin.edit.attendance.id');
			$this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_ITEM_SAVED_FAILED', $model->getError()), 'warning');
			$this->setRedirect(Route::_('index.php?option=com_gavisitsignin&view=attendanceform&layout=edit&id=' . $id, false));
		}

		// Check in the record.
		if ($return) {
			$model->checkin($return);
		}

		// Clear the record id from the session.
		$app->setUserState('com_gavisitsignin.edit.attendance.id', null);

		// Redirect to the list screen.
		$this->setMessage(Text::_('COM_GAVISITSIGNIN_ITEM_SAVED_SUCCESSFULLY'), 'success');
        $link = $app->getMenu()->getActive()->link;
		$url  = (empty($link) ? 'index.php?option=com_gavisitsignin&view=members' : $link);
		$this->setRedirect(Route::_($url, false));

		// Flush the data from the session.
		$app->setUserState('com_gavisitsignin.edit.attendance.data', null);
	}

	/**
	 * Method to abort current operation
	 * @return void
	 * @throws Exception
	 */
	public function cancel($key = NULL)
	{
		$app = Factory::getApplication();

		// Get the current edit id.
		$editId = (int) $app->getUserState('com_gavisitsignin.edit.attendance.id');

		// Get the model.
		$model = $this->getModel('Attendanceform', 'Site');

		// Check in the item
		if ($editId)
		{
			$model->checkin($editId);
		}

        $link = $app->getMenu()->getActive()->link;
        $url = (empty($link) ? 'index.php?option=com_gavisitsignin&view=attendances' : $link);
		$this->setRedirect(Route::_($url, false));
	}

	/**
	 * Method to remove data
	 * @return void
	 * @throws Exception
     * @since 1.6
	 */
	public function remove()
    {
        $app   = Factory::getApplication();
        $model = $this->getModel('Attendanceform', 'Site');
        $pk    = $app->input->getInt('id');

        // Attempt to update the data
        try
        {
            $return = $model->delete($pk);

            // Check in the record
            $model->checkin($return);

            // Clear the record id from the session.
            $app->setUserState('com_gavisitsignin.edit.attendance.id', null);

            $menu = $app->getMenu();
            $item = $menu->getActive();
            $url = (empty($item->link) ? 'index.php?option=com_gavisitsignin&view=attendances' : $item->link);

            // Redirect to the list screen
            $this->setMessage(Text::_('COM_GAVISITSIGNIN_ITEM_DELETED_SUCCESSFULLY'), 'success');
            $this->setRedirect(Route::_($url, false));

            // Flush the data from the session.
            $app->setUserState('com_gavisitsignin.edit.attendance.data', null);
        }
        catch (Exception $e)
        {
            $errorType = ($e->getCode() == '404') ? 'error' : 'warning';
            $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_ITEM_DELETED_FAILED',$e->getMessage()), $errorType);
            $this->setRedirect('index.php?option=com_gavisitsignin&view=attendances');
        }
    }

	/**
	 * Method to archive data
	 * @return void
	 * @throws Exception
     * @since 1.6
	 */
	public function archive()
    {
        $app   = Factory::getApplication();
        $model = $this->getModel('Attendanceform', 'Site');
        $pk    = $app->input->getInt('id');

        // Attempt to update the data
        try
        {
            $return = $model->archive($pk);

            // Check in the record
            $model->checkin($return);

            // Clear the record id from the session.
            $app->setUserState('com_gavisitsignin.edit.attendance.id', null);

            $menu = $app->getMenu();
            $item = $menu->getActive();
            $url = (empty($item->link) ? 'index.php?option=com_gavisitsignin&view=attendances' : $item->link);

            // Redirect to the list screen
            $this->setMessage(Text::_('COM_GAVISITSIGNIN_ITEM_ARCHIVED_SUCCESSFULLY'), 'success');
            $this->setRedirect(Route::_($url, false));

            // Flush the data from the session.
            $app->setUserState('com_gavisitsignin.edit.attendance.data', null);
        }
        catch (Exception $e)
        {
            $errorType = ($e->getCode() == '404') ? 'error' : 'warning';
            $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_ITEM_ARCHIVED_FAILED',$e->getMessage()), $errorType);
            $this->setRedirect('index.php?option=com_gavisitsignin&view=attendances');
        }
    }

	/**
	 * Method to archive data
	 * @return void
	 * @throws Exception
     * @since 1.6
	 */
	public function visitorOut()
    {
        $app   = Factory::getApplication();
        $model = $this->getModel('Attendanceform', 'Site');
        $pk    = $app->input->getInt('id');

        // Attempt to update the data
        try
        {
            $return = $model->visitorOut($pk);

            // Check in the record
            $model->checkin($return);

            // Clear the record id from the session.
            $app->setUserState('com_gavisitsignin.edit.attendance.id', null);

            $menu = $app->getMenu();
            $item = $menu->getActive();
            $url = (empty($item->link) ? 'index.php?option=com_gavisitsignin&view=attendances' : $item->link);

            // Redirect to the list screen
            $this->setMessage(Text::_('COM_GAVISITSIGNIN_VISITOR_OUT_SUCCESSFULLY'), 'success');
            $this->setRedirect(Route::_($url, false));

            // Flush the data from the session.
            $app->setUserState('com_gavisitsignin.edit.attendance.data', null);
        }
        catch (Exception $e)
        {
            $errorType = ($e->getCode() == '404') ? 'error' : 'warning';
            $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_VISITOR_OUT_FAILED',$e->getMessage()), $errorType);
            $this->setRedirect('index.php?option=com_gavisitsignin&view=attendances');
        }
	}

	/**
	 * Method to sign out all remaining attenances.
	 * @return void
	 * @throws Exception
	 * @since  1.6
	 */
	public function signoutall()
	{
		// Check for request forgeries.
		//$this->checkToken();

		// Initialise variables.
		$app   = Factory::getApplication();
		$model = $this->getModel('Members', 'Site');

        // Attempt to update the data
        try
        {
            $return = $model->signOutAllAttendees();

            $menu = $app->getMenu();
            $item = $menu->getActive();
            $url = (empty($item->link) ? 'index.php?option=com_gavisitsignin&view=attendances' : $item->link);

            // Redirect to the list screen
            $this->setMessage(Text::_('COM_GAVISITSIGNIN_ALL_OUT_SUCCESSFULLY'), 'success');
            $this->setRedirect(Route::_($url, false));
        }
        catch (Exception $e)
        {
            $errorType = ($e->getCode() == '404') ? 'error' : 'warning';
            $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_ALL_OUT_FAILED',$e->getMessage()), $errorType);
            $this->setRedirect('index.php?option=com_gavisitsignin&view=attendances');
        }
    }

	/**
	 * Method to signin a barcode.
	 * @return void
	 */
	public function regattend($key = NULL, $urlVar = NULL)
	{
		// Check for request forgeries.
		$this->checkToken();

		// Initialise variables.
		$app   = Factory::getApplication();
		$model = $this->getModel('Attendanceform', 'Site');

		// Get the submitted data.
		$data = $app->input->get('jform', array(), 'array');

		// Validate the form.
		$form = $model->getForm();

		if (!$form) {
			throw new Exception($model->getError(), 500);
		}

		// Validate the posted data.
		$data = $model->validate($form, $data);

		// Check for errors.
		if ($data === false) {
			// Get the validation messages.
			$errors = $model->getErrors();

			// Push up to three validation messages out to the user.
			for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
				if ($errors[$i] instanceof Exception) {
					$app->enqueueMessage($errors[$i]->getMessage(), 'warning');
				} else {
					$app->enqueueMessage($errors[$i], 'warning');
				}
			}
            $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_ITEM_SAVED_FAILED', $model->getError()), 'warning');
		}

		// Attempt to save the data.
		$model->regattend($data);

	}

}
