<?php

/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gavisitsignin\Site\Controller;

// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\Application\SiteApplication;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Multilanguage;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\MVC\Controller\BaseController;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Uri\Uri;
use \Joomla\Utilities\ArrayHelper;
use \Joomla\CMS\Component\ComponentHelper;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GavisitsigninHelper;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GaencryptHelper;

/**
 * Signle record controller class.
 *
 * @since  1.6
 */
class AttendanceController extends BaseController
{
	/**
	 * Method to check out an item for editing and redirect to the edit form.
	 * @return void
	 * @since    1.6
     * @throws Exception
	 */
	public function edit()
	{
		$app = Factory::getApplication();

		// Get the previous edit id (if any) and the current edit id.
		$previousId = (int) $app->getUserState('com_gavisitsignin.edit.attendance.id');
		$editId     = $app->input->getInt('id', 0);

		// Set the user id for the user to edit in the session.
		$app->setUserState('com_gavisitsignin.edit.attendance.id', $editId);

		// Get the model.
		$model = $this->getModel('Attendance', 'Site');

		// Check out the item
		if ($editId)
		{
			$model->checkout($editId);
		}

		// Check in the previous user.
		if ($previousId && $previousId !== $editId)
		{
			$model->checkin($previousId);
		}

		// Redirect to the edit screen.
		$this->setRedirect(Route::_('index.php?option=com_gavisitsignin&view=attendanceform&layout=edit', false));
	}

	/**
	 * Method to save a user's profile data.
	 * @return    void
	 * @throws Exception
	 * @since    1.6
	 */
	public function publish()
	{
		// Initialise variables.
		$app = Factory::getApplication();

		// Checking if the user can remove object
		$user  = $app->getIdentity();

		if ($user->authorise('core.edit', 'com_gavisitsignin') || $user->authorise('core.edit.state', 'com_gavisitsignin'))
		{
			$model = $this->getModel('Attendance', 'Site');

			// Get the user data.
			$id    = $app->input->getInt('id');
			$state = $app->input->getInt('state');

			// Attempt to save the data.
			$return = $model->publish($id, $state);

			// Check for errors.
			if ($return === false)
			{
				$this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_ITEM_SAVED_FAILED', $model->getError()), 'warning');
			}

			// Clear the profile id from the session.
			$app->setUserState('com_gavisitsignin.edit.attendance.id', null);

			// Flush the data from the session.
			$app->setUserState('com_gavisitsignin.edit.attendance.data', null);

			// Redirect to the list screen.
			$this->setMessage(Text::_('COM_GAVISITSIGNIN_ITEM_SAVED_SUCCESSFULLY'), 'success');
			$this->setRedirect(Route::_('index.php?option=com_gavisitsignin&view=attendances', false));
		} else {
			throw new Exception(500);
		}
	}

	/**
	 * Remove data
	 * @return void
	 * @throws Exception
	 */
	public function remove()
	{
		// Initialise variables.
		$app = Factory::getApplication();

		// Checking if the user can remove object
		$user  = $app->getIdentity();

		if ($user->authorise('core.delete', 'com_gavisitsignin'))
		{
			$model = $this->getModel('Attendance', 'Site');

			// Get the user data.
			$id = $app->input->getInt('id', 0);

			// Attempt to save the data.
			$return = $model->delete($id);

			// Check for errors.
			if ($return === false)
			{
				$this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_ITEM_DELETED_FAILED', $model->getError()), 'warning');
			}
			else
			{
				// Check in the profile.
				if ($return)
				{
					$model->checkin($return);
				}

                $app->setUserState('com_gavisitsignin.edit.attendance.id', null);
                $app->setUserState('com_gavisitsignin.edit.attendance.data', null);

                $app->enqueueMessage(Text::_('COM_GAVISITSIGNIN_ITEM_DELETED_SUCCESSFULLY'), 'success');
                $app->redirect(Route::_('index.php?option=com_gavisitsignin&view=attendances', false));
			}

			// Redirect to the list screen.
			//$menu = Factory::getApplication()->getMenu();
			//$item = $menu->getActive();
			$this->setRedirect(Route::_('index.php?option=com_gavisitsignin&view=attendances', false));
		}
		else
		{
			throw new Exception(500);
		}
	}

	/**
	 * Method to cancel a view.
	 * @param   string  $key  The name of the primary key of the URL variable.
	 * @return  boolean  True if access level checks pass, false otherwise.
	 * @since   5.3.0
	 */
	public function cancel($key = null)
	{
		$result = parent::cancel($key);

		//$this->setRedirect(Route::_('index.php?option=com_gavisitsignin&view=attendances', false));
		$this->setRedirect(Route::_($this->getReturnPage(), false));

		return $result;
	}

	/**
	 * Get the return URL.
	 * If a "return" variable has been passed in the request
	 * @return  string    The return URL.
	 * @since   5.3.0
	 */
	protected function getReturnPage()
	{
		$return = $this->input->get('return', null, 'base64');

		if (empty($return) || !Uri::isInternal(base64_decode($return)))
		{
			return Uri::base();
		}

		return base64_decode($return);
	}

	/**
	 * Method to sign in or out a member or visitor.
	 */
	public function signInOut()
	{
		// Initialise variables.
		$app   = Factory::getApplication();

		$model = $this->getModel('Attendance', 'Site');

		$params = ComponentHelper::getParams('com_gavisitsignin');
		$enDecrypt = $params->get('enDecrypt', 0);

		if ($enDecrypt) {
            // using encryption
            $uCode = $app->input->get('s', '');
            $code = Factory::getApplication()->getUserState('com_gavisitsignin.s.code.data');
            // validate passed parameters as a real user
            $sUnCode = GaencryptHelper::GaDecrypt($uCode, $code);
            $vars = explode('&', $sUnCode);
            $mbr  = GavisitsigninHelper::getSpecificUser($vars[1]);
            $result = $vars[2] == $mbr->username ? $model->signInOut($uCode, $mbr) : false;
		} else {
            $sCode     = $app->input->get('s', '');
            $user_id     = $app->input->getInt('user_id', 0);
            $username     = $app->input->get('username', '');
            $mbr  = GavisitsigninHelper::getSpecificUser($user_id);
            $result = $username == $mbr->username ? $model->signInOut(0, $mbr) : false;
            $uCode = false;
        }

		if ($result) {
            if ($uCode) {
                $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_AUTOLOAD_QRMATCH_SUCCESSFULLY', $result), 'success');
            } else {
                $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_AUTOLOAD_SUCCESSFULLY', $result), 'success');
            }
		} else {
            if ($uCode) {
                $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_AUTOLOAD_QRMATCH_FAILED', $result), 'warning');
            } else {
                $this->setMessage(Text::sprintf('COM_GAVISITSIGNIN_AUTOLOAD_FAILED', $result), 'warning');
            }
		}

		// Redirect to the list screen.
        //$link = $app->getMenu()->getActive()->link;
		//$url  = (empty($link) ? 'index.php?option=com_gavisitsignin&view=members' : $link);
		$url  = 'index.php?option=com_gavisitsignin&view=members';
		$this->setRedirect(Route::_($url, false));

	}

}
