<?php

/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gavisitsignin\Administrator\View\Attendance;

// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\MVC\View\GenericDataException;
use \Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use \Joomla\CMS\Toolbar\Toolbar;
use \Joomla\CMS\Toolbar\ToolbarHelper;
use \Joomla\CMS\Helper\ContentHelper;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\HTML\HTMLHelper;
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GavisitsigninHelper;

/**
 * View to edit a record
 * @since  1.6
 */
class HtmlView extends BaseHtmlView
{
	protected $state;

	protected $item;

	protected $form;

	protected $canDo;

	/**
	 * Display the view
	 * @param   string  $tpl  Template name
	 * @return void
	 * @throws Exception
	 */
	public function display($tpl = null)
	{
		$this->state = $this->get('State');
		$this->item  = $this->get('Item');
		$this->form  = $this->get('Form');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new \Exception(implode("\n", $errors), 500);
		}

		$this->addToolbar();

        HTMLHelper::stylesheet(Uri::base().'media/com_gavisitsignin/css/gavisitsignin.css');
        HTMLHelper::stylesheet(Uri::base().'media/com_gavisitsignin/css/form.css');
        HTMLHelper::stylesheet(Uri::base().'media/com_gavisitsignin/css/item.css');

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 * @return void
	 * @throws Exception
	 */
	protected function addToolbar()
	{
		Factory::getApplication()->input->set('hidemainmenu', true);

		$progNameL = 'attendance';
		$user  = GavisitsigninHelper::getSpecificUser();
		$isNew = ($this->item->id == 0);

		if (isset($this->item->checked_out)) {
			$checkedOut = !($this->item->checked_out == 0 || $this->item->checked_out == $user->id);
		} else {
			$checkedOut = false;
		}

		$canDo = ContentHelper::getActions('com_gavisitsignin','component',$this->item->id);

		$customIcon = 'fa-user-check';

		ToolbarHelper::title(Text::_('COM_GAVISITSIGNIN_TITLE_'.STRTOUPPER($progNameL)), $customIcon);

		// If not checked out, can save the item.
		if (!$checkedOut && ($canDo->get('core.edit') || ($canDo->get('core.create')))) {
			ToolbarHelper::apply($progNameL.'.apply', 'JTOOLBAR_APPLY');
			ToolbarHelper::save($progNameL.'.save', 'JTOOLBAR_SAVE');
		}

		if (!$checkedOut && ($canDo->get('core.create'))) {
			ToolbarHelper::save2new($progNameL.'.save2new', 'JTOOLBAR_SAVE_AND_NEW');
		}

		// If an existing item, can save to a copy.
		if (!$isNew && $canDo->get('core.create')) {
			ToolbarHelper::save2copy($progNameL.'.save2copy', 'JTOOLBAR_SAVE_AS_COPY');
		}

		// Button for version control
		if ($this->state->params->get('save_history', 1) && $user->authorise('core.edit')) {
			ToolbarHelper::versions('com_gavisitsignin.'.$progNameL, $this->item->id);
		}

		if (empty($this->item->id)) {
			ToolbarHelper::cancel($progNameL.'.cancel', 'JTOOLBAR_CANCEL');
		} else {
			ToolbarHelper::cancel($progNameL.'.cancel', 'JTOOLBAR_CLOSE');
		}

	}
}
