<?php

/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gavisitsignin\Administrator\Helper;

// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\Factory;
use \Joomla\Data\DataObject;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\MVC\Model\ListModel;
use \Joomla\CMS\MVC\Model\BaseDatabaseModel;
use \Joomla\CMS\Installer\Installer;
use \Joomla\Filesystem\Path;
use \Joomla\CMS\Toolbar\Toolbar;
use \Joomla\CMS\Toolbar\ToolbarHelper;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Component\ComponentHelper;
use \Joomla\CMS\User\UserHelper;
use \Joomla\CMS\User\UserFactoryInterface;
use \Joomla\CMS\Categories\Categories;
use \Joomla\CMS\Table\Table;
use \Joomla\CMS\Date\Date;
use \Joomla\CMS\Access\Access;
use \Joomla\CMS\Router\Route;
use \Joomla\Database\ParameterType;   //INTEGER, STRING, BOOLEAN, NULL, LARGE_OBJECT
use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\GaencryptHelper;
//use \GlennArkell\Component\Gavisitsignin\Administrator\Helper\phpqrcode\phpqrcode;
use \GlennArkell\Component\Gausers\Administrator\Helper\GainvoiceHelper;

/**
 * Gavisitsignin helper.
 *
 */
class GavisitsigninHelper
{
	/**
	 * Build the HTTP query array
	 * @param array of the http query if the http query already prepared and we want to add more
	 * @param string view or a task
	 * @param string control method to be used
	 * @param string reference indicator
	 * @param string/int reference string or id
	 * @return array
	 * @ hint - this is used with http_build_query($query_string, '', '&amp;') to build a clean url
	 */
	public static function getHTTPQuery($existQ = null, $viewTask = 'view', $contModel = 'members', $ref = 'id', $linkId = 0)
	{
		if (!$existQ) {
			$query_string = array();
			$query_string['option'] = 'com_gavisitsignin';
			$query_string[$viewTask] = $contModel;
			if ($ref) {
				$query_string[$ref] = $linkId;
			}
		} else {
			$query_string = $existQ;
			$query_string[$ref] = $linkId;
		}

		return $query_string;
	}

    /**
     * Create the sign in or out link
     * @param   string  $encryptedString excryption data
     * @return  string URL
     */
//    public static function signInOut($id)
    public static function signInOut($encryptedString)
    {
        $params = ComponentHelper::getParams('com_gavisitsignin');
        $enDecrypt = $params->get('enDecrypt', 0);
        if ($enDecrypt) {
            $signinLink = self::getHTTPQuery(null, 'task', 'attendance.signInOut', 's', $encryptedString);
        } else {
            $signinLink = self::getHTTPQuery(null, 'task', 'attendance.signInOut', 's', $encryptedString['s']);
            $signinLink = self::getHTTPQuery($signinLink, null, null, 'user_id', $encryptedString['user_id']);
            $signinLink = self::getHTTPQuery($signinLink, null, null, 'username', $encryptedString['username']);
        }
        $signinURL = 'index.php?'.\http_build_query($signinLink, '', '&amp;');

		return $signinURL;
	}

    /**
     * Gets todays date based on global timezone settings
     */
    public static function getTodaysDate()
	{
        //$today = Factory::getDate()->toSql();  //returns a datetime string
        //$today = date_format(Factory::getDate(),'Y-m-d');  //returns a date string
        //$today = date_format(Factory::getDate(),'Y-m-d H:i:s');  //returns a datetime string same as ->toSql()
        //$today = date_format(Factory::getDate('now', 'Australia/Melbourne'),'Y-m-d');  //returns a date string in local timezone
		//$tz = Factory::getConfig()->get('offset');
		//$date = Factory::getDate('now', $tz);
		//$today = date_format($date,'Y-m-d H:i:s');
		//$today = date_format(Factory::getDate('now', 'Australia/Melbourne'),'Y-m-d');
		$today = Factory::getDate()->toSql();  // returns datetime string for UTC

		return $today;
	}

    /**
     * Gets the user record for the specific id reference
     */
    public static function getSpecificUser($id = 0)
	{
		if ($id) {
			$container = Factory::getContainer();
			$userFactory = $container->get(UserFactoryInterface::class);
			$user = $userFactory->loadUserById($id);
		} else {
			$user = Factory::getApplication()->getIdentity();
		}

		return $user;
	}

    /**
     * Load template over-rides when using modal view
     * This is important for Cloud White template scheme
     */
    public static function loadTmplStyleModal($wa)
	{
        $tmpl = Factory::getApplication()->getTemplate(true);
        if ($tmpl->params->get('colorName') == 'colors_white') {
        	$wa->addInlineStyle('.btn-primary {background-color:'.$tmpl->params->get('btnPbgColor').' !important;}');
        	$wa->addInlineStyle('.nav-link {color:var(--template-contrast) !important;}');
        	$wa->addInlineStyle('.form-check-input:checked, .form-select[multiple] option:checked, [multiple].custom-select option:checked {background-color:'.$tmpl->params->get('btnPbgColor').' !important;}');
        	$wa->addInlineStyle('.page-item.active .page-link {color: var(--rkic41site-color-link); background-color: #c1cee1 !important; border-color: #dfe3e7 !important;}');
        	$wa->addInlineStyle('.form-select[multiple] option:checked, [multiple].custom-select option:checked {background-color: var(--rkic41site-color-primary-border) !important;}');
        }
		return true;
	}

    /**
     * Gets the edit permission for an user
     * @param   mixed  $item  The item
     * @return  bool
     */
    public static function canUserEdit($item)
    {
        $permission = false;
        $user       = GavisitsigninHelper::getSpecificUser();

        if ($user->authorise('core.edit', 'com_gavisitsignin')) {
            $permission = true;
        } else {
            if (isset($item->created_by)) {
                if ($user->authorise('core.edit.own', 'com_gavisitsignin') && $item->created_by == $user->id) {
                    $permission = true;
                }
            } else {
                $permission = false;
            }
        }

        return $permission;
    }

    /**
     * Prints out a variable value in human readable format
     */
    public static function gaPrint($val){
        echo '<pre>Test<br />';
        \print_r($val);
        echo  '</pre>';
    }

	/**
	 * Get the version of the component
	 * @return version element of manifest
	 */
	public static function getComponentVersion()
	{
		$componentXML = Installer::parseXMLInstallFile(Path::clean(JPATH_ADMINISTRATOR . '/components/com_gavisitsignin/gavisitsignin.xml'));

		return $componentXML['version'];
	}

    /**
     * Gets a category name from id reference
     */
    public static function getCategoryName($id) {

        // get the club names from the database
        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->select(' title ')
			->from($db->quoteName('#__categories '))
			->where(' id = :id' )
    		->bind(':id', $id, ParameterType::INTEGER);
		$db->setQuery($query);

	    try {
	        return $db->loadResult();
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
	        return false;
	    }
    }

    /**
     * Gets a custom field record for a item_id and field_id
     */
    public static function getCustomField($item_id = 0, $field_id = 0) {

        // get the club names from the database
        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->select(' value ')
			->from($db->quoteName('#__fields_values '))
			->where($db->quoteName('field_id') . ' = :field_id' )
			->where($db->quoteName('item_id') . '= :item_id' )
    		->bind(':field_id', $field_id, ParameterType::INTEGER)
    		->bind(':item_id', $item_id, ParameterType::STRING);
		$db->setQuery($query);

	    try {
	        return $db->loadResult();
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
	        return false;
	    }
    }

    /**
     * Gets all items relating to a specific custom field_id and value
     */
    public static function getAllCustomFieldRecs($field_id = 0, $rec_value = 0) {

        // get the club names from the database
        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->select(' item_id ')
			->from($db->quoteName('#__fields_values '))
			->where($db->quoteName('field_id') . ' = :field_id' )
			->where($db->quoteName('value') . ' = :rec_value' )
    		->bind(':field_id', $field_id, ParameterType::INTEGER)
    		->bind(':rec_value', $rec_value, ParameterType::STRING);
		$db->setQuery($query);

	    try {
	        return $db->loadColumn();
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
	        return false;
	    }
    }

	public static function getListOptions($table = '#__gavisitsignin_attendances', $label = 'Attendance', $field = 'a.user_id' )
	{
        $sel_label = Text::sprintf('COM_GAVISITSIGNIN_SELECT', $label);
		$db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->select(' "0" as "value", " - '.$sel_label.' - " as "text" UNION SELECT a.id as value, '.$field.' as text ');
		$query->from( $db->quoteName($table) . ' AS a ' );
		if ($table == '#__users') {
			$query->where(' a.block = 0' );
		} else {
			$query->where(' a.state = 1' );
		}
		$query->order(' text ASC ' );
		$db->setQuery((string)$query);

	    try {
	        $options = $db->loadObjectList();
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(),'danger');
	        return false;
	    }

		return $options;
	}

	public static function getCustomFieldOptions()
	{
		$sel_field = Text::_('COM_GAVISITSIGNIN_SELECT_FIELD');
		// get the user custom field records
        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->select(' "0" as "value", " - '.$sel_field.' - " as "text" UNION SELECT id as value, title as text ');
		$query->from( $db->quoteName('#__fields') );
		$query->where(' context = "com_users.user"' );
		$query->order(' text ASC ' );
		$db->setQuery((string)$query);

	    try {
	        $options = $db->loadObjectList();
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(),'danger');
	        return false;
	    }

		return $options;
	}

	public static function getProfileFieldsOptions()
	{
		$sel_field = Text::_('COM_GAVISITSIGNIN_SELECT_FIELD');

		// get the user profile records
        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->select(' "0" as "value", " - '.$sel_field.' - " as "text" UNION SELECT profile_key as value, substr(profile_key,9) as text ');
		$query->from( $db->quoteName('#__user_profiles') );
		$query->group(' profile_key ' );
		$query->order(' text ASC ' );
		$db->setQuery((string)$query);

	    try {
	        $options = $db->loadObjectList();
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(),'danger');
	        return false;
	    }

		return $options;
	}

    /**
     * Check if signin record exists
     * Used in default view to change badge to green/red and from AttendanceModel::signInOut
     * @param   integer  $user_id
     * @param   date  $todays date converted to local time
     * @return  object single record if exists
     */
    public static function checkSignInDate($user_id, $today) {

        $tzone = new \DateTimeZone('Australia/Melbourne');
        // Create a DateTime object representing the current time in UTC
        // The offset is dependent on a specific point in time due to DST changes
        $utcTime = new \DateTime("now", new \DateTimeZone("UTC"));
        // Get the offset in seconds for the specified timezone at the given UTC time
        $offsetInSeconds = $tzone->getOffset($utcTime);
        // Convert the offset to hours for easier readability
        $offsetInHours = $offsetInSeconds / 3600;
        $tz = "+" . $offsetInHours . ":00";

        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->select(' * ')
            ->select(" date_format(CONVERT_TZ(clockin_date, '+00:00', :tz), '%Y-%m-%d') AS clockinDate ")
            ->select(" date_format(CONVERT_TZ(clockout_date, '+00:00', :tz), '%Y-%m-%d') AS clockoutDate ")
    		->from(' #__gavisitsignin_attendances ')
    		->where(' user_id = :user_id' )
    		->where(' state = 1 ' )
    		->where(" date_format(CONVERT_TZ(clockin_date, '+00:00', :tz), '%Y-%m-%d') = :today" )
    		->where(' clockout_date IS NULL ' )
    		->order(' clockin_date DESC LIMIT 1 ' )
    		->bind(':user_id', $user_id, ParameterType::INTEGER)
    		->bind(':tz', $tz, ParameterType::STRING)
    		->bind(':today', $today, ParameterType::STRING);
		$db->setQuery($query);

	    try {
	        return $db->loadObject();
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
	        return false;
	    }
    }

    /**
     * Get previous signin record for user
     * @param   integer  $user_id
     * @param   date  $signInDate
     * @return  object record if it exists
     */
    public static function getLastSignInDate($user_id, $signInDate) {

        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->select(' * ' )
    		->from($db->quoteName('#__gavisitsignin_attendances'))
    		->where($db->quoteName('user_id') . ' = :user_id')
    		->where($db->quoteName('clockin_date') . ' <= :clockin_date')
    		->order('clockin_date DESC LIMIT 1' )
    		->bind(':user_id', $user_id, ParameterType::INTEGER)
    		->bind(':clockin_date', $signInDate, ParameterType::STRING);
		$db->setQuery($query);

	    try {
	        return $db->loadObject();
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
	        return false;
	    }
    }

    /**
     * Get the attendance record
     * @param   integer  $id reference to attendance record
     * @return  object record if it exists
     */
    public static function getAttendanceRecord($id = 0) {

        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->select(' * ')
    		->from($db->quoteName('#__gavisitsignin_attendances'))
    		->where($db->quoteName('id') . ' = :id')
    		->bind(':id', $id, ParameterType::INTEGER);
		$db->setQuery($query);

	    try {
	        return $db->loadObject();
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
	        return false;
	    }
    }

    /**
     * Check if signin record exists
     */
//     public static function checkSignOutDate($user_id, $today) {
// 
//         $signOutDate = substr($today,0,10);
// 
//         $db		= Factory::getContainer()->get('DatabaseDriver');
// 		$query	= $db->getQuery(true);
//         $query->clear();
// 		$query->select(' id ');
// 		$query->from(' #__gavisitsignin_attendances ');
// 		$query->where(' user_id = '.(int) $user_id );
// 		$query->where(' substr(clockout_date,1,10) = '. $db->Quote($signOutDate) );
// 		$query->where(' clockout_date <= '. $db->Quote($today) . ' ORDER BY clockout_date DESC LIMIT 1' );
// 		$db->setQuery((string)$query);
// 
// 	    try {
// 	        return $db->loadResult();
// 	    } catch (RuntimeException $e) {
// 	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
// 	        return false;
// 	    }
//     }

    /**
     * Get all records un-signed out
     * @params  date $today in format of CCYY-MM-DD
     * @return  list
     */
//     public static function getUnSignedOut($today) {
// 
//         $signOutDate = date_format(Factory::getDate(),'Y-m-d');
// 
//         $db		= Factory::getContainer()->get('DatabaseDriver');
// 		$query	= $db->getQuery(true);
//         $query->clear();
// 		$query->select(' id ');
// 		$query->from(' #__gavisitsignin_attendances ');
// 		$query->where(' user_id = '.(int) $user_id );
// 		$query->where(' substr(clockin_date,1,10) = '. $db->Quote($signOutDate) );
// 		$query->where(' clockout_date IS NULL' );
// 		$db->setQuery((string)$query);
// 
// 	    try {
// 	        return $db->loadObjectList();
// 	    } catch (RuntimeException $e) {
// 	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
// 	        return false;
// 	    }
//     }

    /**
     * Sign Out all records un-signed out
     * @param   integer  $user_id
     * @return  boolean true on success or false
     */
    public static function signInAllRemaining($user_id = 0) {

        $signOutDate = date_format(Factory::getDate(),'Y-m-d');
        $today = Factory::getDate()->toSql();

        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->update(' #__gavisitsignin_attendances ')
    		->set(' modified_by = :user_id' )
    		->set(' clockout_date = :today' )
    		->set(' modified_date = :today' )
    		->where(' substr(clockin_date,1,10) <= :signOutDate' )
    		->where(' clockout_date IS NULL' )
    		->bind(':user_id', $user_id, ParameterType::INTEGER)
    		->bind(':today', $today, ParameterType::STRING)
    		->bind(':signOutDate', $signOutDate, ParameterType::STRING);
		$db->setQuery($query);

	    try {
	        $db->execute();
	        return true;
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
	        return false;
	    }
    }

    /**
     * Sign Out all records un-signed out
     * @param   date  $datefr start date of selected range
     * @param   date  $dateto end date of selected range, blank = today
     * @return  associative array list
     */
    public static function getAttendancesExport($dateFr, $dateTo) {

        $params = ComponentHelper::getParams('com_gavisitsignin');
        $tzone = new \DateTimeZone('Australia/Melbourne');
        // Create a DateTime object representing the current time in UTC
        // The offset is dependent on a specific point in time due to DST changes
        $utcTime = new \DateTime("now", new \DateTimeZone("UTC"));
        // Get the offset in seconds for the specified timezone at the given UTC time
        $offsetInSeconds = $tzone->getOffset($utcTime);
        // Convert the offset to hours for easier readability
        $offsetInHours = $offsetInSeconds / 3600;
        $tz = "+" . $offsetInHours . ":00";

        $endDate = $dateTo ? $dateTo : date_format(Factory::getDate(),'Y-m-d');
        //$tz = date_format(Factory::getDate(),'m-d') >= $dstStart && date_format(Factory::getDate(),'m-d') <= $dstEnd ? '+11:00' : '+10:00';

        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		//$query->select(' a.user_id, a.clockin_date, a.clockout_date, u.name as UserName, u.registerDate, u.lastvisitDate ');
		$query->select($db->quoteName('user_id'))
            ->select(" CONVERT_TZ(clockin_date, '+00:00', :tz) AS clockinDate ")
            ->select(" CONVERT_TZ(clockout_date, '+00:00', :tz) AS clockoutDate ")
    		->select($db->quoteName('u.name') . ' as UserName' )
            ->select(" CONVERT_TZ(u.registerDate, '+00:00', :tz) AS registerDate ")
            ->select(" IF (u.lastvisitDate IS NULL,'Never Logged In',CONVERT_TZ(u.lastvisitDate, '+00:00', :tz)) AS lastLoginDate ")
    		->from($db->quoteName('#__gavisitsignin_attendances'))
    		->join('LEFT', ' #__users u ON u.id = user_id ');
		if (!empty($dateFr)) {
            $query->where(' substr(clockin_date,1,10) >= :dateFr');
        }
    	$query->where(' substr(clockin_date,1,10) <= :endDate')
    		->where($db->quoteName('state') . ' = 1')
    		->order(" SUBSTRING_INDEX(SUBSTRING_INDEX(u.name, ' ', 4), ' ', -1) ASC, clockin_date ASC " )
    		->bind(':dateFr', $dateFr, ParameterType::STRING)
    		->bind(':endDate', $endDate, ParameterType::STRING)
    		->bind(':tz', $tz, ParameterType::STRING);
		$db->setQuery($query);

	    try {
	        return $db->loadAssocList();
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
	        return false;
	    }
    }

    /**
     * Gets a list of users
     * used from AttendancesModel::showMIA
     */
    public static function getMIArecords($mias = 60) 
    {
        $params = ComponentHelper::getParams('com_gavisitsignin');
        //$dstStart = $params->get('dstStart', '10-05');
        //$dstEnd = $params->get('dstEnd', '04-05');
        $ignoreUsers = $params->get('ignore_gp');
        $defaultGp = $params->get('group_id');
        $invStartDate = ComponentHelper::getParams('com_gausers')->get('invoice_date');
        //$tz = date_format(Factory::getDate(),'m-d') >= $dstStart && date_format(Factory::getDate(),'m-d') <= $dstEnd ? '+11:00' : '+10:00';
        $tzone = new \DateTimeZone('Australia/Melbourne');
        // Create a DateTime object representing the current time in UTC
        // The offset is dependent on a specific point in time due to DST changes
        $utcTime = new \DateTime("now", new \DateTimeZone("UTC"));
        // Get the offset in seconds for the specified timezone at the given UTC time
        $offsetInSeconds = $tzone->getOffset($utcTime);
        // Convert the offset to hours for easier readability
        $offsetInHours = $offsetInSeconds / 3600;
        $tz = "+" . $offsetInHours . ":00";

        $today = Factory::getDate()->toSql();
        // get date less the period of time set in the filters
        $date = Factory::getDate()->modify('-'.$mias.' day')->format('Y-m-d H:i:s');
        // setup last paid up end date
        $prevUser = 0;

        // get the names from the database
        $db		= Factory::getContainer()->get('DatabaseDriver');
		$query	= $db->getQuery(true);
        $query->clear();
		$query->select(' u.id AS userId, u.name AS username ')
            ->select(" CONVERT_TZ(a.clockin_date, '+00:00', :tz) AS clockinDate ")
            ->select(" CONVERT_TZ(u.registerDate, '+00:00', :tz) AS registerDate ")
            ->select(" IF (u.lastvisitDate IS NULL,'Never Logged In',CONVERT_TZ(u.lastvisitDate, '+00:00', :tz)) AS lastLoginDate ")
			->from($db->quoteName('#__users').' AS u')
			->join('LEFT', '#__gavisitsignin_attendances AS a ON a.user_id = u.id ' )
			->join('LEFT', '#__user_usergroup_map AS g ON g.user_id = u.id AND g.group_id = :groupId' )
			->where('g.group_id IS NOT NULL')
    		->order("SUBSTRING_INDEX(SUBSTRING_INDEX(u.name, ' ', 4), ' ', -1) ASC, a.clockin_date DESC ")
    		->bind(':tz', $tz, ParameterType::STRING)
    		->bind(':groupId', $defaultGp, ParameterType::INTEGER);
		$db->setQuery($query);

	    try {
	        $items = $db->loadObjectList();
	        foreach ($items as $item) {
                if ($item->username == $prevUser) { continue; } else {$prevUser = $item->username;}
                if ($item->clockinDate <= $date) {
                    if (in_array($item->userId, $ignoreUsers)) { continue; }
                    $mship = GainvoiceHelper::getLastInvoiceMship($item->userId);
                    // if not financial this current year
                    if (date_format(Factory::getDate($mship->end_date),'Y-m-d') < $invStartDate) { continue; }
                    $item->lastMship = $mship->end_date;
                    $recs[] = $item;
                }
            }
            return $recs;
	    } catch (RuntimeException $e) {
	        Factory::getApplication()->enqueueMessage($e->getMessage(), 'danger');
	        return false;
	    }
    }

}

