<?php

/**
 * @version    5.3.0
 * @package    Com_Gavisitsignin
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2020 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gavisitsignin\Administrator\Helper;

// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\Factory;
use \Joomla\CMS\Component\ComponentHelper;

/**
 * Encryption helper.
 * 1st set up the encryption object with the used elements so the 
 * same elements can be used in the decryption process.
 * 2nd encrypt a string provided - currently using 2 elements
 * separated by an "&" so that the string can be converted to an array.
 * All done and now you have an encrypted string.
 * 3rd decrypt the string by using the same encryption object.
 */
class GaencryptHelper
{
	/**
	 * Set up the encryption elements for use
     * @return  object
	 */
    public static function GaSetupCrypt()
    {
        $code = new \stdClass();

		$params = ComponentHelper::getParams('com_gavisitsignin');
        // Get your secret key and cipher method
        $code->key = $params->get('secureIt','');
        $code->method = $params->get('methOd','aes-256-cbc');
        //$code->method = 'aes-256-cbc'; // AES-256 in CBC mode is a common choice

        // Generate a random initialization vector (IV)
        // The IV should be unique for each encryption and can be stored with the ciphertext
        $iv_length = \openssl_cipher_iv_length($code->method);
        $code->iv = \openssl_random_pseudo_bytes($iv_length);
        $code->encoded_iv = \base64_encode($code->iv);
        
        Factory::getApplication()->setUserState('com_gavisitsignin.s.code.data', $code);

        return $code;

    }

	/**
	 * Build an encrypted string
     * @param   string  $plaintext  The details to be encrypted
     * @param   object  $code  The encryption elements
     * @return  string
	 */
    public static function GaEncrypt($plaintext, $code)
    {
        // Encrypt the string
        $encrypted_string = \openssl_encrypt($plaintext, $code->method, $code->key, 0, $code->iv);
        
        // Encode the encrypted string and IV for safe storage/transmission (e.g., Base64)
        $encoded_encrypted_string = \base64_encode($encrypted_string);

        //echo '<span style="color:white;">Original String: <br />' . $plaintext . '<br />';
        //echo 'Encrypted String (Base64 encoded): ' . $encoded_encrypted_string . '<br />';
        //echo 'Initialization Vector (Base64 encoded): ' . $code->encoded_iv . '<br />';

        return $encoded_encrypted_string;

    }

	/**
	 * Decrypted a string
     * @param   string  $encoded_encrypted_string  The encrypted string
     * @param   object  $code  The encryption elements
     * @return  string
	 */
    public static function GaDecrypt($encoded_encrypted_string, $code)
    {
        // To decrypt (for demonstration)
        $decoded_encrypted_string = \base64_decode($encoded_encrypted_string);
        $decoded_iv = \base64_decode($code->encoded_iv);
        $decrypted_string = \openssl_decrypt($decoded_encrypted_string, $code->method, $code->key, 0, $decoded_iv);

        //echo 'Decrypted String: <br />' . $decrypted_string . '<br /></span>';

        return $decrypted_string;

    }

}

