CREATE TABLE IF NOT EXISTS #__gavisitsignin_attendances (
`id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
`ordering` INT  NOT NULL DEFAULT 0,
`state` TINYINT  NOT NULL DEFAULT 1,
`checked_out` INT  NOT NULL DEFAULT 0,
`checked_out_time` DATETIME NULL,
`created_by` INT  NOT NULL DEFAULT 0,
`created_date` DATETIME NULL,
`modified_by` INT  NOT NULL DEFAULT 0,
`modified_date` DATETIME NULL,
`user_id` INT  NOT NULL DEFAULT 0,
`clockin_date` DATETIME NULL,
`clockout_date` DATETIME NULL,
`visit_who` VARCHAR(255) NULL,
`name` VARCHAR(255) NULL ,
`phone` VARCHAR(32) NULL,
`address` VARCHAR(255) NULL ,
`suburb` VARCHAR(255) NULL,
`postcode` VARCHAR(32) NULL,
`comment` TEXT NULL ,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__content_types` (`type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `content_history_options`)
SELECT * FROM ( SELECT 'Attendance','com_gavisitsignin.attendance','{"special":{"dbtable":"#__gavisitsignin_attendances","key":"id","type":"AttendanceTable","prefix":"GlennArkell\\\\Component\\\\Gavisitsignin\\\\Administrator\\\\Table\\\\"}}', CASE
                                WHEN 'rules' is null THEN ''
                                ELSE ''
                                END as rules, CASE
                                WHEN 'field_mappings' is null THEN ''
                                ELSE ''
                                END as field_mappings, '{"formFile":"administrator\/components\/com_gavisitsignin\/forms\/attendance.xml", "hideFields":["checked_out","checked_out_time","params","language" ,"comment"], "ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"group_id","targetTable":"#__usergroups","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}') AS tmp
WHERE NOT EXISTS (
	SELECT type_alias FROM `#__content_types` WHERE (`type_alias` = 'com_gavisitsignin.attendance')
) LIMIT 1;


